﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using PpmsDataWebService.VistaPharmacyModels;
using PpmsDataWebService.ModelsEnumTypes;
using VA.PPMS.Context;
using Microsoft.Xrm.Client.Messages;
using Microsoft.Xrm.Sdk;
using Microsoft.Xrm.Sdk.Query;
using System.Diagnostics;
using Microsoft.Xrm.Sdk.Messages;

namespace PpmsDataWebService.Mappers
{
    public class VistaPharmacyProviderServicesMap
    {
        public static async Task<IQueryable<VistaPharmacyProviderService>> MapVistaPharmacyProviderServices(List<ppms_providerservice> ppmsProviderServices,string queryType, IOrganizationService _service)
        {
            var providerServicesList = new List<VistaPharmacyProviderService> { };           
            int count = 0;
            
            foreach (var ppmsProviderService in ppmsProviderServices)
            {
                count += 1;
                var providerService = new VistaPharmacyProviderService
                {
                    ProviderNPI = ppmsProviderService.ppms_provideridentifer,
                    SpecialtyCode = ppmsProviderService.ppms_specialtycode,
                    AddressStreet1 = ppmsProviderService.ppms_caresiteaddress,
                    AddressCity = ppmsProviderService.ppms_caresitecity,
                    AddressState = ppmsProviderService.ppms_caresitestateprovince,
                    AddressZip = ppmsProviderService.ppms_caresitezipcode,
                    OfficePhone = ppmsProviderService.ppms_caresitephonenumber
                };

                if (ppmsProviderService.ppms_latitude != null)
                {
                    providerService.Latitude = (decimal)ppmsProviderService.ppms_latitude;
                }
                if (ppmsProviderService.ppms_longitude != null)
                {
                    providerService.Longitude = (decimal)ppmsProviderService.ppms_longitude;
                }

                if (ppmsProviderService.StatusCode != null)
                    switch (ppmsProviderService.StatusCode.Value)
                    {
                        case (int)ppms_providerservice_StatusCode.Active:
                            providerService.ProviderServiceStatus = ProviderServiceStatusReason.Active;
                            break;
                        case (int)ppms_providerservice_StatusCode.Pending:
                            providerService.ProviderServiceStatus = ProviderServiceStatusReason.Pending;
                            break;
                        case (int)ppms_providerservice_StatusCode.AddressValidationFailure:
                            providerService.ProviderServiceStatus = ProviderServiceStatusReason.AddressValidationFailure;
                            break;
                        case (int)ppms_providerservice_StatusCode.Inactive:
                            providerService.ProviderServiceStatus = ProviderServiceStatusReason.Inactive;
                            break;
                    }

                providerServicesList.Add(providerService);              
            }          
            var provServices = providerServicesList.AsQueryable();
            return provServices;
        }
    }
}